
#include <map>
#include <unordered_map>
#include <boost/algorithm/string.hpp>
#include <vector>
#include <mutex>
#include <chrono>
#include <iostream>
#include <fstream>
#include "ThreadPool.h"
#include "evidence.hpp"
#include "external.hpp"
#include "functions.hpp"

using namespace std;

void check_haploview()
{
    
    v_vcf = v_input;
    v_out = v_output;
    
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 0, Program_name + "::haploview" , 1, v_quiet);
    screen_message (screen_size, 2, "Loading data ...", 2, v_quiet);
    
    string line;
    ifstream myfile (v_vcf);
    int format_index = -1;
    vector <string> haploview_samples;
    vector <string> haploview_sample_list;
    map <string, string> haplo_data;
    map <int,string> haploview_snps;
    
    while ( getline (myfile,line) )
    {
        if (line.substr(0,2) == "##") {continue;}
        if (line.substr(0,2) == "#C")
        {
            boost::split(haploview_samples,line,boost::is_any_of("\t"));
            int vindex = 0;
            for(auto &&item: haploview_samples)
            {
                if (item == "FORMAT") {format_index = vindex;}
                vindex++;
            }
            
            for (int b = format_index + 1; b < haploview_samples.size(); b++) {haploview_sample_list.push_back(haploview_samples[b]);}
            
            continue;
        }
        if (line == "") {continue;}
     
        
        vector <string> check;
        boost::split(check,line,boost::is_any_of("\t"));

        if (check[4].size() > 1) {continue;}
        if (check[3].size() > 1) {continue;}

        
        
        int start_int = 0;
        if (vstart != "0")
        {
            try {
                start_int = stoi(vstart);
            }
            catch (const std::exception& e) {
                start_int = 0;
            }
        }
     
        int end_int = 0;
        if (vend != "0")
        {
            try {
                end_int = stoi(vend);
            }
            catch (const std::exception& e) {
                end_int = 0;
            }
        }
     
     
        if (v_chr != "")
        {
            if (v_chr != check[0]){continue;}
        }
        if (start_int > 0)
        {
            if (stoi(check[1]) < start_int){continue;}
        }
        if (end_int > 0)
        {
            if (stoi(check[1]) > end_int) {break;}
        }

        vector <string> allele_list;
        allele_list.push_back(check[3]);
        allele_list.push_back(check[4]);
 
        haploview_snps[stoi(check[1])] = check[0] + "\t" + check[2] + "\t0\t" + check[1];
        
        for (int a = format_index + 1; a < check.size(); a++)
        {
            string sample = haploview_samples[a];
            vector <string> itens;
            boost::split(itens,check[a],boost::is_any_of(":"));
            vector <string> alleles;
            boost::split(alleles,itens[0],boost::is_any_of("/"));
            if (alleles.size() == 1) {boost::split(alleles,itens[0],boost::is_any_of("|"));}
            if (alleles[0] != ".") {alleles[0] = allele_list[stoi(alleles[0])];}
            if (alleles[1] != ".") {alleles[1] = allele_list[stoi(alleles[1])];}
            if (alleles[0] == ".") {alleles[0] = "N";}
            if (alleles[1] == ".") {alleles[1] = "N";}
            haplo_data[sample] = haplo_data[sample] + " " + alleles[0] + " " + alleles[1];
        }
        
    }
    myfile.close();
    screen_message (screen_size, 2, "Loading ... done", 1, v_quiet);
    screen_message (screen_size, 2, "Printing PED/INFO file ... ", 2, v_quiet);

    ofstream out;
    out.open (v_out);
    out.close();
    out.open(v_out, std::ios_base::app);
    
    for(auto &&item: haploview_sample_list)
    {
        out << item << " " << item << " 0 0 0 0";
        out << haplo_data[item] << endl;
    }
    out.close();

    string v_info = GetFileNameWithoutExtension (v_input) + ".map";
    ofstream info;
    info.open (v_info);
    info.close();
    info.open(v_info, std::ios_base::app);
    
    for(auto &&item: haploview_snps)
    {
        info << item.second << endl;
    }
    info.close();
    
    
    screen_message (screen_size, 2, "Printing PED/INFO file ... done", 1, v_quiet);

    
    
    screen_message (screen_size, 2, "Output file: " + v_output, 1, v_quiet);
    
}


void help_haploview ()
{
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 0, Program_name + "::haploview" , 1, 0);
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 2, "* Author  : " + Program_author, 1, 0);
    screen_message (screen_size, 2, "* Contact : " + Program_contact, 1, 0);
    screen_message (screen_size, 2, "* Version : " + Program_version, 1, 0);
    screen_message (screen_size, 0, "", 1, 0);
    screen_message (screen_size, 2, "Options", 1, 0);
    screen_message (screen_size, 5, "input      the input VCF file [mandatory]", 1, 0);
    screen_message (screen_size, 5, "output     the PED file to be created", 1, 0);
    screen_message (screen_size, 5, "chr        the chromosome to be considered", 1, 0);
    screen_message (screen_size, 5, "start      start processing from this position", 1, 0);
    screen_message (screen_size, 5, "end        process variants to this position", 1, 0);
    screen_message (screen_size, 5, "--quiet    quiet mode", 1, 0);
    screen_message (screen_size, 0, "", 1, 0);
    PrintWarnings();
    return;
}

void main_haploview ()
{
    if (! fileExists(v_input)) {warnings.push_back("The input file could not be found.");help_haploview();return;}
    if (v_output == "") {v_output = GetFileNameWithoutExtension (v_input) + ".ped";}
    check_haploview();
    return;
}
