#include <iostream>
#include <fstream>
#include <vector>
#include <map>
#include <sys/stat.h>
#include <boost/algorithm/string.hpp>
#include <vector>


#include "functions.hpp"
#include "external.hpp"

using namespace std;

void screen_message (int size, int left, string message, int enter, int quiet)
{
    if(quiet == 1) {return;
    }
    if ((message.length()+left) > size) {message = message.substr(0,(size-left-1));}
    cout << "\r";
    for (int a = 0; a < left; a++){cout << " ";}
    cout << message;
    for (int a = 0; a < (((size-left)-message.length())); a++){cout << " ";}
    std::cout.flush();
    if (enter == 1) {cout << endl;}
    return;
}


bool fileExists(const std::string& filename)
{
    struct stat buf;
    if (stat(filename.c_str(), &buf) != -1)
    {
        return true;
    }
    return false;
}

string findfilepath (string v_file)
{
    string v_filename = v_file.substr(0,(v_file.find_last_of("/"))+1);
    return (v_filename);
}

string GetStdoutFromCommand(string cmd) {
    
    string data;
    FILE * stream;
    const int max_buffer = 256;
    char buffer[max_buffer];
    cmd.append(" 2>&1");
    
    stream = popen(cmd.c_str(), "r");
    if (stream) {
        while (!feof(stream))
            if (fgets(buffer, max_buffer, stream) != NULL) data.append(buffer);
        pclose(stream);
    }
    return data;
}



string GetFileNameWithoutExtension (string file)
{
    if (file == "") {return "";}
    for (int a = file.length(); a > 0; a--)
    {
        if (file.substr(a,1) == ".")
        {
            string res = file.substr(0,a);
            return res;
        }
    }
    return "";
}


void PrintWarnings ()
{
    if (warnings.size() > 0)
    {
        screen_message (screen_size, 2, "Warnings: " + warnings[0], 1, 0);
        for (int a = 1; a < warnings.size(); a++) {
            screen_message (screen_size, 2, "          " + warnings[a], 1, 0);
        }
    }
    warnings.clear();
}


bool checkIsSTR(int arr[], int n)
{
    if (n == 1)
        return true;
    sort(arr, arr + n);
    
    int d = arr[1] - arr[0];
    for (int i=2; i<n; i++)
        if (arr[i] - arr[i-1] != d)
            return false;
    return true;
}
